
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */

/**
 * Classe que representa a bala do heri
 */
public class Fire extends GameObject {

    /**
     * Construtor
     * @param x, Posio x inicial
     * @param y, Posio y inicial
     * @param v, Se est visvel ou no
     * @param initialSequence Sequencia inicial que representam o inimigo
     *
     */
    public Fire(int x, int y, boolean v, int[] initialSequence) {

        super(x, y, Constants.bulletImage, 3, 4, initialSequence);
        super.setXspeed(0);
        super.setYspeed(-5);
        super.setVisible(v);
    }

    /**
     * Constructor Fire
     *
     * @param x, Posio x inicial
     * @param y, Posio y inicial
     * @param v, Se est visvel ou no
     * @param initialSequence Sequencia inicial que representam o inimigo
     * @param xspeed, Velocidade vertical da bala
     * @param yspeed, Velocidade horizontal da bala
     *
     */
    public Fire(int x, int y, boolean v, int[] initialSequence, int xspeed,
                int yspeed) {

        super(x, y, Constants.bulletImage, 
        		Constants.BULLET_FRAME_WIDTH, Constants.BULLET_FRAME_HEIGHT, initialSequence);
        super.setXspeed(xspeed);
        super.setYspeed(yspeed);
        super.setVisible(v);
    }

    /* ************************************************************
     * O frame a ser rederizado  controlado pelo frame sequence.
     * Assim, no  necessrio redefinir o a lgica de pintura, 
     * isto , o mtodo paint(Graphics).
     * ************************************************************/

    /**
     * Atualiza a posio da bala
     */
    public void update() {

        if(super.isVisible()) {
            // se saiu da tela, fica invisivel
            if((getY() < -this.getHeight())
                || (getY() > Constants.HEIGHT)) {
                super.setVisible(false);
            }

            // atualiza posio de acordo com velocidades
            super.applySpeed();
        }
    }
}
